package com.richard_gauthier.CompteurLCD 
{
	import com.richard_gauthier.TexteEnBitmap.TexteEnBitmap;
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	/**
	 * ...
	 * @author rg
	 */
	public class CompteurLCD extends Sprite
	{	[Embed(source="bar5.png")]
		private var bar1C:Class;
		private var afficheur : Bitmap = new bar1C;
		
		private var leTexte:TextField = new TextField();
		public var couleurG:uint = 0x040adc;
		
		private var transEnbitmap:TexteEnBitmap = new TexteEnBitmap();
		private var monBitmap:Bitmap;
		
		public function CompteurLCD(leTitre:String = "Le Titre", unite:String = "Unité", couleur : uint = 0xffffff) 
		{
			addChild(afficheur);
		    
			couleurG = couleur;
			
			
			var formatTexte:TextFormat = new TextFormat();
			formatTexte.font = "tahoma";
			formatTexte.size = 60;
			//formatTexte.bold = true;
			formatTexte.color = couleur;
			formatTexte.align = TextFormatAlign.CENTER;
			
			leTexte.width = 10;
			leTexte.height = 60;
			leTexte.autoSize = TextFieldAutoSize.CENTER;
			leTexte.defaultTextFormat = formatTexte;
			leTexte.text =  "999.9";
			leTexte.x = afficheur.width / 2 - leTexte.width / 2;
			leTexte.y = afficheur.height / 2 - leTexte.height / 2;
			setValue(000.0);
		    addChild(leTexte);
		
			//Placer le titre
			label(leTitre, afficheur.width / 2, leTexte.y / 2 + 10);
			
			
			//Placer l'unité
			label(unite, afficheur.width / 2 , leTexte.y + leTexte.height , 6);
				
		}
		
		public function setValue(value:Number):void
		{
			var texte:String = "" + value;
			
			if (texte.length > 4)
					texte = texte.substr(0, 4);
			
			leTexte.text = "" + value;
		}
		
				
		private function label(texte:String, posiX:Number, posiY:Number, NbCaracteres:int = -1):void
		{
			if (NbCaracteres > 0)
				if (texte.length > NbCaracteres)
					texte = texte.substr(0, NbCaracteres);
			
			monBitmap = new Bitmap(transEnbitmap.transformerTexteEnBitmap(texte,couleurG));
			monBitmap.x = posiX - monBitmap.width / 2;
			//528
			monBitmap.y = posiY;
			monBitmap.cacheAsBitmap = true;
			
			addChild(monBitmap);
		
			//leTexteMesure.addEventListener(MouseEvent.CLICK,mouseClick)
		
		}
		
	}

}